import Layout from "@/app/components/layout";
import StageWiseChaptersList from "./StageWiseChaptersList";
import { getAllCEStatus, getChaptersStages} from '@/lib/services/chapterService';
import { getAllStatus, getAllMDStatus  } from "@/lib/services/entryService";
import { getceEditorList} from '@/lib/services/copyeditingService';
import { getServerSession } from "next-auth";
import authOptions from "@/app/api/auth/[...nextauth]/authOptions";

export const dynamic = "force-dynamic"; // ensures fresh DB read

export default async function ChaptersListByStagewise(props) {
  // console.log(props,"props");
  
const params = await props.params;
  // params
  // console.log(params,"paramsparamsparams");
  // console.log(params?.slug,"params?.slug")
  
  const session = await getServerSession(authOptions);
  const userId = session?.user?.user_pid;
  const slug = params?.slug || []; // catch-all param — always an array

  // Join multiple parts and split by comma (e.g., "FC,FCR" => ["FC", "FCR"])
  const rawStatuses = slug?.flatMap((s) => s.split(','));

  // Custom logic: if only 'FC', also include 'FCR'
  // const statusArray =
  //   rawStatuses.length === 1 && rawStatuses[0] === 'FC'
  //     ? ['FC', 'FCR']
  //     : rawStatuses;
  const statusArray =
    rawStatuses.length === 1 && rawStatuses[0] === 'FC'
      ? ['FC', 'FCR']
    : rawStatuses.length === 1 && rawStatuses[0] === 'RC'
    ? ['RCR1', 'RCR2']
      : rawStatuses;
  let stagename = "";
  // let chapters = "";
  if (rawStatuses[0] == "FC") {
    stagename = "Stage - First Check"
  } else if (rawStatuses[0] == "FCQC") {
    stagename = "Stage - First Check QC"
  } else if (rawStatuses[0] == "EDA") {
    stagename = "Stage - Editor Assignment"
  } else if (rawStatuses[0] == "PR") {
    stagename = "Stage - Peer Review"
  }  else if (rawStatuses[0] == "MD") {
    stagename = "Stage - Make Decision"
  }  else if (rawStatuses[0] == "CE") {
    stagename = "Stage - Copy Editing"
  }  else if (rawStatuses[0] == "RC") {
    stagename = "Stage - Revision Check"
  }  else if (rawStatuses[0] == "ER") {
    stagename = "Stage - Editor Recommendation"
  }
  //const chapters = await getChaptersStages(statusArray);
  let chapters;
  if(rawStatuses[0] == "CE")
  {
    chapters = await getAllCEStatus();
    
  } else {
     chapters = await getChaptersStages(statusArray);
  }  
  const initialstatus = await getAllStatus();
  const initialMDstatus = await getAllMDStatus();
  const initialCEstatus = await getAllCEStatus();
  const ceEditorList    = await getceEditorList();

  return (
    <Layout>
      <StageWiseChaptersList
        initialStageChapters={chapters}
        stagename={stagename}
        status={rawStatuses[0]}
        initialstatus={initialstatus}
        initialMDstatus={initialMDstatus}
        initialCEstatus={initialCEstatus}
        userId={userId}
        editorList={ceEditorList}
      />
    </Layout>
  );
}
